﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using System.Web;
using System.Xml;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessManager;

public partial class TBI_Instruments_Warning : System.Web.UI.Page
{
    private UserAccountManager _currentUser;

    protected void Page_Load(object sender, EventArgs e)
    {
        Master.FindControl("UserInformation").Visible = false;
        switch (Request.QueryString["err"])
        {
            case "1": HandleErrorType1(); break;
            case "9": HandleErrorType9(); break;
            case "11": HandleErrorType11(); break;
            case "12345": HandleErrorType12345(); break;
            //Page already contains the message for the default value of 2 so we don't need to do anything
            case "2":
            default: break;
        }
    }

    private void HandleErrorType1()
    {
        string _returnErrorXML = String.Empty;
        string messageVal = String.Empty;
        string suggestionVal = String.Empty;

        //RETRIEVE DATA
        if (_currentUser == null)
        {
            Reports r = new Reports("vbacohassed");//hardcode my user for debugging
            DataTable dtConnectionErrors = r.GetTBIConnectionError().Copy();
            dtConnectionErrors.TableName = "MDWS_LOG";

            foreach (DataRow _error in dtConnectionErrors.Rows)
            {
                _returnErrorXML = _error["ERROR_XML"].ToString();
            }
        }
        else
        {
            if (_currentUser.UserId.ToString().Length > 0)
            {
                Reports r = new Reports(_currentUser.UserId.ToString());
                DataTable dtConnectionErrors = r.GetTBIConnectionError().Copy();
                dtConnectionErrors.TableName = "MDWS_LOG";

                foreach (DataRow _error in dtConnectionErrors.Rows)
                {
                    _returnErrorXML = _error["ERROR_XML"].ToString();
                }
            }
        }

        if (_returnErrorXML.Length > 0)
        {
            XmlReaderSettings settings = null;
            XmlReader reader = null;
            XmlDocument xmlDoc = null;

            try
            {
                settings = new XmlReaderSettings();
                settings.DtdProcessing = DtdProcessing.Prohibit;
                settings.XmlResolver = null;
                reader = XmlReader.Create(new System.IO.StringReader(_returnErrorXML), settings);
                if (reader != null)
                {
                    //CREATE NEW XML DOC WITH RECORD XML
                    xmlDoc = new XmlDocument();
                    xmlDoc.Load(reader);

                    if (xmlDoc != null && xmlDoc.HasChildNodes)
                    {
                        //PARSE OUT ERROR MESSASE FIELD DATA
                        XmlNodeList elementList = xmlDoc.GetElementsByTagName("messageField");
                        if (elementList != null)
                        {
                            for (int i = 0; i < elementList.Count; i++)
                            {
                                messageVal = elementList[i].InnerText;
                            }
                        }

                        //PARSE OUT ERROR SUGGESTION FIELD DATA
                        XmlNodeList elementList2 = xmlDoc.GetElementsByTagName("suggestionField");
                        if (elementList2 != null)
                        {
                            for (int i = 0; i < elementList2.Count; i++)
                            {
                                suggestionVal = elementList2[i].InnerText;
                            }
                        }
                    }
                }
            }
            finally
            {
                xmlDoc = null;

                if (reader != null)
                {
                    reader.Close();
                    reader.Dispose();
                    reader = null;
                }

                settings = null;
            }

            //DISPLAY RETURNED XML ERROR TEXT TO USER
            LabelMessage.Text = "MDWS could not make a connection to the CPRS system requested." + "<br />";
            if (messageVal.Length > 0)
            {
                lblDataMessage.Text += "<b>VISTA site error message:</b> <font color='red'>" + messageVal + "</font><br />";
            }
            else
            {
                lblDataMessage.Text += "<b>VISTA site error message:</b> <font color='red'>N/A</font><br />";
            }

            if (suggestionVal.Length > 0)
            {
                lblSuggestionText.Text += "<b>VISTA site error suggestion:</b> <font color='red'>" + suggestionVal + "</font><br />";
            }
            else
            {
                lblSuggestionText.Text += "<b>VISTA site error suggestion:</b> <font color='red'>N/A</font><br />";
            }
        }
        else
        {
            LabelMessage.Text = "MDWS could not make a connection to the CPRS system requested.";
        }
    }

    private void HandleErrorType9()
    {
        LabelMessage.Text = "Data for this patient was modified in a concurrent session.";
    }

    private void HandleErrorType11()
    {
        LabelMessage.Text = "An internal error has occurred that requires termination of this program.  Please close all browsers that you have open in this application.";
    }

    private void HandleErrorType12345()
    {
        LabelMessage.Text = "VIA could not make a connection to the CPRS system requested.";
    }
}
